<?php
/* --------------------------------------------------------------
   CacheFactory.php 2020-04-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Cache;

use Psr\SimpleCache\CacheInterface;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Interface CacheFactory
 *
 * @package Gambio\Core\Cache
 */
interface CacheFactory
{
    /**
     * @param string $namespace
     *
     * @return CacheInterface
     *
     * @throws InvalidArgumentException
     */
    public function createCacheFor(string $namespace): CacheInterface;
}